/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.item;

import com.technicalitiesmc.lib.container.item.ItemContainerSlice;
import com.technicalitiesmc.lib.container.item.SimpleItemContainer;
import com.technicalitiesmc.lib.container.item.adapter.ContainerToItemContainerAdapter;
import com.technicalitiesmc.lib.container.item.adapter.ItemContainerToContainerAdapter;
import com.technicalitiesmc.lib.container.item.adapter.ItemContainerToItemHandlerAdapter;
import com.technicalitiesmc.lib.container.item.adapter.ItemHandlerToItemContainerAdapter;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Contract;

public interface ItemContainer
extends Iterable<ItemStack> {
    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static Serializable of(int slots) {
        return new SimpleItemContainer(slots);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static Serializable copyOf(@Nonnull NonNullList<ItemStack> items) {
        return new SimpleItemContainer(items);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer wrap(@Nonnull Container container) {
        return new ContainerToItemContainerAdapter(container);
    }

    @Nonnull
    @Contract(value="_ -> new", pure=true)
    public static ItemContainer wrap(@Nonnull IItemHandler itemHandler) {
        return new ItemHandlerToItemContainerAdapter(itemHandler);
    }

    @Contract(pure=true)
    public int size();

    @Nonnull
    public ItemStack get(int var1);

    public void set(int var1, @Nonnull ItemStack var2);

    @Contract(pure=true)
    public boolean isValid(int var1, @Nonnull ItemStack var2);

    @Contract(pure=true)
    default public int getMaxStackSize(int slot) {
        return 64;
    }

    default public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, ItemStack.f_41583_);
        }
    }

    @Contract(pure=true)
    default public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    @Contract(value="-> new", pure=true)
    default public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            final int size;
            int i;
            {
                this.size = ItemContainer.this.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public ItemStack next() {
                return ItemContainer.this.get(this.i++);
            }
        };
    }

    @Nonnull
    @Contract(value="_, _ -> new", pure=true)
    default public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new ItemContainerSlice(this, from, to - from);
    }

    @Nonnull
    @Contract(pure=true)
    default public IItemHandlerModifiable asItemHandler() {
        return new ItemContainerToItemHandlerAdapter(this);
    }

    @Nonnull
    @Contract(pure=true)
    default public Container asVanillaContainer() {
        return new ItemContainerToContainerAdapter(this);
    }

    @Nonnull
    @Contract(pure=true)
    default public NonNullList<ItemStack> copyToList() {
        NonNullList list = NonNullList.m_122780_((int)this.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.size(); ++i) {
            list.set(i, (Object)this.get(i).m_41777_());
        }
        return list;
    }

    public static interface Serializable
    extends ItemContainer,
    INBTSerializable<CompoundTag> {
        @Nonnull
        @Contract(pure=true)
        public CompoundTag save();

        public void load(@Nonnull CompoundTag var1);

        default public CompoundTag serializeNBT() {
            return this.save();
        }

        default public void deserializeNBT(CompoundTag tag) {
            this.load(tag);
        }
    }
}

